using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class LAB_ORDER_STATICDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public LAB_ORDER_STATICDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public LAB_ORDER_STATIC GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string TO_NAME)
		{
			LAB_ORDER_STATIC objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_LAB_ORDER_STATIC_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, TO_NAME).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<LAB_ORDER_STATIC> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<LAB_ORDER_STATIC> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_LAB_ORDER_STATIC_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public string Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, LAB_ORDER_STATIC objSave)
		{
			string objReturn = objSave.TO_NAME;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_LAB_ORDER_STATIC_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BVAMC_CONTACT_BEEPER, objSave.BVAMC_CONTACT_FAX, objSave.BVAMC_CONTACT_NAME, objSave.CLIENT_ADDR1, objSave.CLIENT_ADDR2, objSave.CLIENT_ADDR3, objSave.CLIENT_CITY, objSave.CLIENT_COMPANY, objSave.CLIENT_CONTACT, objSave.CLIENT_FAX, objSave.CLIENT_NAME, objSave.CLIENT_PHONE, objSave.CLIENT_POSTALCODE, objSave.CLIENT_STATE, objSave.CLIENT_ZIPPLUS4, objSave.HAZARD_ID, objSave.PAYMENT, objSave.REPLY_TO_ADDR1, objSave.REPLY_TO_ADDR2, objSave.REPLY_TO_ADDR3, objSave.REPLY_TO_CITY, objSave.REPLY_TO_COMPANY, objSave.REPLY_TO_NAME, objSave.REPLY_TO_POSTALCODE, objSave.REPLY_TO_STATE, objSave.REPLY_TO_ZIPPLUS4, objSave.TO_ADDR1, objSave.TO_ADDR2, objSave.TO_ADDR3, objSave.TO_CITY, objSave.TO_COMPANY, ref objReturn, objSave.TO_NAME_ID, objSave.TO_POSTALCODE, objSave.TO_STATE, objSave.TO_ZIPPLUS4, objSave.TURNAROUND);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string TO_NAME)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_LAB_ORDER_STATIC_delete(CURRENT_USER, CURRENT_REGISTRY_ID, TO_NAME);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
